/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.java.syntaxtoken.LastSyntaxTokenFinder;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2972", name="Inner classes should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class InnerClassTooManyLinesCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 25;
    @RuleProperty(key="Max", description="The maximum number of lines allowed", defaultValue="25")
    public int max = 25;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        ClassTree node = (ClassTree)tree;
        Symbol.TypeSymbol symbol = node.symbol();
        Symbol owner = symbol.owner();
        Type ownerType = owner.type();
        if (ownerType != null && ownerType.isClass() && owner.owner().isPackageSymbol()) {
            int first = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)node).line();
            int last = LastSyntaxTokenFinder.lastSyntaxToken((Tree)node).line();
            int length = last - first + 1;
            if (length > this.max) {
                this.addIssue((Tree)node, "Reduce this class from " + length + " to the maximum allowed " + this.max + " or externalize it in a public class.");
            }
        }
    }
}

