/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2142", name="\"InterruptedException\" should not be ignored", priority=Priority.CRITICAL, tags={"bug", "cwe", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="15min")
public class InterruptedExceptionCheck
extends SubscriptionBaseVisitor {
    private Deque<Boolean> withinInterruptingFinally = new LinkedList<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRY_STATEMENT);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() != null) {
            super.scanFile(context);
        }
        this.withinInterruptingFinally.clear();
    }

    public void visitNode(Tree tree) {
        TryStatementTree tryStatementTree = (TryStatementTree)tree;
        this.withinInterruptingFinally.addFirst(this.isFinallyInterrupting(tryStatementTree.finallyBlock()));
        for (CatchTree catchTree : tryStatementTree.catches()) {
            if (!catchTree.parameter().symbol().type().is("java.lang.InterruptedException")) continue;
            BlockVisitor blockVisitor = new BlockVisitor(catchTree.parameter().symbol());
            catchTree.block().accept((TreeVisitor)blockVisitor);
            if (blockVisitor.threadInterrupted || this.isWithinInterruptingFinally()) continue;
            this.reportIssue((Tree)catchTree.parameter(), "Either re-interrupt this method or rethrow the \"InterruptedException\".");
        }
    }

    private boolean isWithinInterruptingFinally() {
        for (Boolean aBoolean : this.withinInterruptingFinally) {
            if (!aBoolean.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void leaveNode(Tree tree) {
        this.withinInterruptingFinally.removeFirst();
    }

    private boolean isFinallyInterrupting(@Nullable BlockTree blockTree) {
        if (blockTree == null) {
            return false;
        }
        BlockVisitor blockVisitor = new BlockVisitor();
        blockTree.accept((TreeVisitor)blockVisitor);
        return blockVisitor.threadInterrupted;
    }

    private static class BlockVisitor
    extends BaseTreeVisitor {
        @Nullable
        private final Symbol catchedException;
        boolean threadInterrupted = false;

        public BlockVisitor() {
            this.catchedException = null;
        }

        public BlockVisitor(Symbol catchedException) {
            this.catchedException = catchedException;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (tree.symbol().owner().type().isSubtypeOf("java.lang.Thread") && "interrupt".equals(tree.symbol().name()) && tree.arguments().isEmpty()) {
                this.threadInterrupted = true;
                return;
            }
            super.visitMethodInvocation(tree);
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)tree.expression()).symbol().equals(this.catchedException)) {
                this.threadInterrupted = true;
                return;
            }
            super.visitThrowStatement(tree);
        }
    }
}

