/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1318", name="\"object == null\" should be used instead of \"object.equals(null)\"", priority=Priority.CRITICAL, status="DEPRECATED", tags={})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ObjectEqualsNullCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        super.visitMethodInvocation(tree);
        if (ObjectEqualsNullCheck.isCallToEquals(tree.methodSelect()) && tree.arguments().size() == 1 && ObjectEqualsNullCheck.isNull((ExpressionTree)tree.arguments().get(0))) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree, "Use \"object == null\" instead of \"object.equals(null)\" to test for nullity to prevent null pointer exceptions.");
        }
    }

    private static boolean isCallToEquals(ExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return false;
        }
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)tree;
        return "equals".equals(memberSelect.identifier().name());
    }

    private static boolean isNull(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }
}

