/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ObjectFinalizeOverridenCheck", name="The Object.finalize() method should not be overriden", priority=Priority.MAJOR, tags={"cert", "unpredictable"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ObjectFinalizeOverridenCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ObjectFinalizeOverridenCheck.isFinalize(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Do not override the Object.finalize() method.");
        }
    }

    private static boolean isFinalize(MethodTree methodTree) {
        TypeTree returnType;
        if ("finalize".equals(methodTree.simpleName().name()) && (returnType = methodTree.returnType()) != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE})) {
            return "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }
}

