/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1226", name="Method parameters, caught exceptions and foreach variables should not be reassigned", priority=Priority.MAJOR, tags={"misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ParameterReassignedToCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Set<Symbol> variables = Sets.newHashSet();
    private JavaFileScannerContext context;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.variables.clear();
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        this.scan((Tree)context.getTree());
    }

    private boolean hasSemanticModel() {
        return this.semanticModel != null;
    }

    public void visitMethod(MethodTree tree) {
        for (VariableTree parameterTree : tree.parameters()) {
            this.variables.add(parameterTree.symbol());
        }
        super.visitMethod(tree);
        for (VariableTree parameterTree : tree.parameters()) {
            this.variables.remove(parameterTree.symbol());
        }
    }

    public void visitCatch(CatchTree tree) {
        this.variables.add(tree.parameter().symbol());
        super.visitCatch(tree);
        this.variables.remove(tree.parameter().symbol());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.checkExpression(tree.variable());
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (ParameterReassignedToCheck.isIncrementOrDecrement((Tree)tree) && tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkExpression(tree.expression());
        }
    }

    private static boolean isIncrementOrDecrement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_INCREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT});
    }

    private void checkExpression(ExpressionTree tree) {
        IdentifierTree identifier;
        Symbol reference;
        if (this.hasSemanticModel() && tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (reference = (identifier = (IdentifierTree)tree).symbol()).isVariableSymbol() && this.variables.contains(reference)) {
            this.context.reportIssue((JavaCheck)this, (Tree)identifier, "Introduce a new variable instead of reusing the parameter \"" + identifier.name() + "\".");
        }
    }
}

