/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2131", name="Primitives should not be boxed just for \"String\" conversion", priority=Priority.MAJOR, tags={"performance"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class PrimitiveTypeBoxingWithToStringCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodInvocationMatcherCollection TO_STRING_MATCHERS = PrimitiveTypeBoxingWithToStringCheck.getToStringMatchers("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    private static MethodInvocationMatcherCollection getToStringMatchers(String ... typeFullyQualifiedNames) {
        MethodInvocationMatcherCollection matchers = MethodInvocationMatcherCollection.create();
        for (String fullyQualifiedName : typeFullyQualifiedNames) {
            matchers.add(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf(fullyQualifiedName)).name("toString"));
        }
        return matchers;
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree abstractTypedTree;
        if (TO_STRING_MATCHERS.anyMatch(tree) && ((abstractTypedTree = ((MemberSelectExpressionTree)tree.methodSelect()).expression()).is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) || PrimitiveTypeBoxingWithToStringCheck.isValueOfInvocation(abstractTypedTree))) {
            String typeName = abstractTypedTree.symbolType().toString();
            this.createIssue((Tree)tree, typeName);
        }
        super.visitMethodInvocation(tree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            this.checkConcatenation((Tree)tree, tree.leftOperand(), tree.rightOperand());
        }
        super.visitBinaryExpression(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        JavaType wrapper = ((JavaType)tree.expression().symbolType()).primitiveWrapperType();
        if (tree.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT}) && tree.variable().symbolType().is("java.lang.String") && wrapper != null) {
            this.createIssue((Tree)tree, wrapper.name());
        }
        super.visitAssignmentExpression(tree);
    }

    private void createIssue(Tree reportingTree, String wrapperName) {
        this.context.reportIssue((JavaCheck)this, reportingTree, "Use \"" + wrapperName + ".toString\" instead.");
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        this.scan((Tree)annotationTree.annotationType());
    }

    private void checkConcatenation(Tree tree, ExpressionTree leftOperand, ExpressionTree rightOperand) {
        JavaType wrapper = null;
        if (PrimitiveTypeBoxingWithToStringCheck.isEmptyString(leftOperand)) {
            wrapper = ((JavaType)rightOperand.symbolType()).primitiveWrapperType();
        } else if (PrimitiveTypeBoxingWithToStringCheck.isEmptyString(rightOperand)) {
            wrapper = ((JavaType)leftOperand.symbolType()).primitiveWrapperType();
        }
        if (wrapper != null) {
            this.createIssue(tree, wrapper.name());
        }
    }

    private static boolean isEmptyString(ExpressionTree expressionTree) {
        return expressionTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && LiteralUtils.trimQuotes((String)((LiteralTree)expressionTree).value()).isEmpty();
    }

    private static boolean isValueOfInvocation(ExpressionTree abstractTypedTree) {
        if (!abstractTypedTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        Type type = abstractTypedTree.symbolType();
        MethodMatcher valueOfMatcher = MethodMatcher.create().typeDefinition(type.fullyQualifiedName()).name("valueOf").addParameter(((JavaType)type).primitiveType().fullyQualifiedName());
        return valueOfMatcher.matches((MethodInvocationTree)abstractTypedTree);
    }
}

