/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2122", name="\"ScheduledThreadPoolExecutor\" should not have 0 core threads", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ScheduledThreadPoolExecutorZeroCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Increase the \"corePoolSize\".";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.util.concurrent.ThreadPoolExecutor")).name("setCorePoolSize").addParameter("int"), (Object)MethodMatcher.create().typeDefinition("java.util.concurrent.ScheduledThreadPoolExecutor").name("<init>").addParameter("int"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
        if (ScheduledThreadPoolExecutorZeroCheck.isZeroIntLiteral(arg)) {
            this.reportIssue((Tree)arg, MESSAGE);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        ExpressionTree arg = (ExpressionTree)newClassTree.arguments().get(0);
        if (ScheduledThreadPoolExecutorZeroCheck.isZeroIntLiteral(arg)) {
            this.reportIssue((Tree)arg, MESSAGE);
        }
    }

    private static boolean isZeroIntLiteral(ExpressionTree arg) {
        return arg.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && "0".equals(((LiteralTree)arg).value());
    }
}

