/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2092", name="Cookies should be \"secure\"", priority=Priority.CRITICAL, tags={"cwe", "owasp-a2", "owasp-a6", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="5min")
public class SecureCookieCheck
extends SubscriptionBaseVisitor {
    private List<Symbol.VariableSymbol> unsecuredCookies = Lists.newArrayList();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.unsecuredCookies.clear();
        super.scanFile(context);
        for (Symbol.VariableSymbol unsecuredCookie : this.unsecuredCookies) {
            this.reportIssue((Tree)unsecuredCookie.declaration().simpleName(), "Add the \"secure\" attribute to this cookie");
        }
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                this.addToUnsecuredCookies(variableTree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                this.checkSecureCall(mit);
            }
        }
    }

    private void addToUnsecuredCookies(VariableTree variableTree) {
        Symbol variableSymbol;
        Type type = variableTree.type().symbolType();
        if (type.is("javax.servlet.http.Cookie") && SecureCookieCheck.isConstructorInitialized(variableTree) && (variableSymbol = variableTree.symbol()).isVariableSymbol() && variableSymbol.owner().isMethodSymbol()) {
            this.unsecuredCookies.add((Symbol.VariableSymbol)variableSymbol);
        }
    }

    private void checkSecureCall(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse;
        if (SecureCookieCheck.isSetSecureCall(mit) && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (mse = (MemberSelectExpressionTree)mit.methodSelect()).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol reference = ((IdentifierTree)mse.expression()).symbol();
            this.unsecuredCookies.remove(reference);
        }
    }

    private static boolean isConstructorInitialized(VariableTree variableTree) {
        ExpressionTree initializer = variableTree.initializer();
        return initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS});
    }

    private static boolean isSetSecureCall(MethodInvocationTree mit) {
        boolean hasArityOne;
        Symbol methodSymbol = mit.symbol();
        boolean bl = hasArityOne = mit.arguments().size() == 1;
        if (hasArityOne && SecureCookieCheck.isCallSiteCookie(methodSymbol)) {
            ExpressionTree expressionTree = (ExpressionTree)mit.arguments().get(0);
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL}) && "false".equals(((LiteralTree)expressionTree).value())) {
                return false;
            }
            return "setSecure".equals(SecureCookieCheck.getIdentifier(mit).name());
        }
        return false;
    }

    private static boolean isCallSiteCookie(Symbol methodSymbol) {
        return methodSymbol.isMethodSymbol() && methodSymbol.owner().type().is("javax.servlet.http.Cookie");
    }

    private static IdentifierTree getIdentifier(MethodInvocationTree mit) {
        IdentifierTree id = mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)mit.methodSelect() : ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
        return id;
    }
}

