/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2112", name="\"URL.hashCode\" and \"URL.equals\" should be avoided", priority=Priority.MAJOR, tags={"performance"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class URLHashCodeAndEqualsCheck
extends SubscriptionBaseVisitor {
    private static final String JAVA_NET_URL = "java.net.URL";
    private static final MethodInvocationMatcherCollection URL_MATCHERS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition("java.net.URL").name("equals").addParameter("java.lang.Object"), MethodMatcher.create().typeDefinition("java.net.URL").name("hashCode"));

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            Type variableType;
            VariableTree variableTree = (VariableTree)tree;
            if (variableTree.initializer() != null && URLHashCodeAndEqualsCheck.isSubTypeOfSetOrMap(variableType = variableTree.type().symbolType()) && URLHashCodeAndEqualsCheck.usesURLAsTypeParameter(variableType)) {
                this.reportIssue((Tree)variableTree.type(), "Use the URI class instead.");
            }
        } else if (this.hasSemantic() && URL_MATCHERS.anyMatch((MethodInvocationTree)tree)) {
            this.reportIssue(tree, "Use the URI class instead.");
        }
    }

    private static boolean isSubTypeOfSetOrMap(Type type) {
        return type.isSubtypeOf("java.util.Set") || type.isSubtypeOf("java.util.Map");
    }

    private static boolean usesURLAsTypeParameter(Type type) {
        Type firstTypeParameter = URLHashCodeAndEqualsCheck.getFirstTypeParameter(type);
        return firstTypeParameter != null && firstTypeParameter.is(JAVA_NET_URL);
    }

    @CheckForNull
    private static Type getFirstTypeParameter(Type type) {
        JavaType.ParametrizedTypeJavaType parametrizedTypeType;
        Iterator i$;
        if (type instanceof JavaType.ParametrizedTypeJavaType && (i$ = (parametrizedTypeType = (JavaType.ParametrizedTypeJavaType)type).typeParameters().iterator()).hasNext()) {
            JavaType.TypeVariableJavaType variableType = (JavaType.TypeVariableJavaType)i$.next();
            return parametrizedTypeType.substitution(variableType);
        }
        return null;
    }
}

