/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S923", name="Functions should not be defined with a variable number of arguments", priority=Priority.INFO, tags={"cert", "misra", "pitfall"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="1min")
public class VarArgCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        SyntaxToken ellipsisToken;
        TypeTree lastParam;
        List parameters = ((MethodTree)tree).parameters();
        if (!parameters.isEmpty() && (lastParam = ((VariableTree)parameters.get(parameters.size() - 1)).type()).is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE}) && (ellipsisToken = ((ArrayTypeTree)lastParam).ellipsisToken()) != null) {
            this.reportIssue((Tree)ellipsisToken, "Do not use varargs.");
        }
    }
}

