/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1844", name="\"Object.wait(...)\" should never be called on objects that implement \"java.util.concurrent.locks.Condition\"", priority=Priority.BLOCKER, tags={"bug", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class WaitOnConditionCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        TypeCriteria conditionSubType = TypeCriteria.subtypeOf("java.util.concurrent.locks.Condition");
        return ImmutableList.builder().add((Object)MethodMatcher.create().callSite(conditionSubType).name("wait")).add((Object)MethodMatcher.create().callSite(conditionSubType).name("wait").addParameter("long")).add((Object)MethodMatcher.create().callSite(conditionSubType).name("wait").addParameter("long").addParameter("int")).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }
}

