/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.LinkedList;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ExpressionsHelper {
    private ExpressionsHelper() {
    }

    public static ExpressionTree skipParentheses(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (result.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    public static String concatenate(@Nullable ExpressionTree tree) {
        if (tree == null) {
            return "";
        }
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }
}

