/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.ejb;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.w3c.dom.Node;

@Rule(key="S3282", name="EJB interceptor exclusions should be declared as annotations", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="15min")
public class InterceptorExclusionsCheck
extends XPathXmlCheck {
    private XPathExpression notDefaultInterceptorBindingsExpression;
    private XPathExpression exclusionsExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.notDefaultInterceptorBindingsExpression = context.compile("ejb-jar/assembly-descriptor/interceptor-binding[ejb-name!=\"*\"]");
        this.exclusionsExpression = context.compile("*[self::exclude-default-interceptors[text()=\"true\"] or self::exclude-class-interceptors[text()=\"true\"]]");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        for (Node interceptorBinding : context.evaluateOnDocument(this.notDefaultInterceptorBindingsExpression)) {
            this.checkExclusions(context, interceptorBinding);
        }
    }

    private void checkExclusions(XmlCheckContext context, Node interceptorBinding) {
        for (Node exclusion : context.evaluate(this.exclusionsExpression, interceptorBinding)) {
            this.reportIssue(exclusion, "Move this exclusion into the class as an annotation.");
        }
    }
}

