/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2116", name="\"hashCode\" and \"toString\" should not be called on array instances", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayHashCodeAndToStringCheck
extends AbstractMethodDetection {
    private static final TypeCriteria IS_ARRAY = new IsArrayCriteria();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)ArrayHashCodeAndToStringCheck.arrayMethodInvocation("toString"), (Object)ArrayHashCodeAndToStringCheck.arrayMethodInvocation("hashCode"));
    }

    private static MethodMatcher arrayMethodInvocation(String methodName) {
        return MethodMatcher.create().callSite(IS_ARRAY).name(methodName);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "Use \"Arrays." + methodName + "(array)\" instead.");
    }

    private static class IsArrayCriteria
    extends TypeCriteria {
        private IsArrayCriteria() {
        }

        @Override
        public boolean matches(Type type) {
            return type.isArray();
        }
    }
}

