/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2447", name="Null should not be returned from a \"Boolean\" method", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class BooleanMethodReturnCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (BooleanMethodReturnCheck.returnsBoolean(methodTree)) {
            methodTree.accept((TreeVisitor)new ReturnStatementVisitor());
        }
    }

    private static boolean returnsBoolean(MethodTree methodTree) {
        TypeTree returnType = methodTree.returnType();
        return returnType != null && returnType.symbolType().is("java.lang.Boolean");
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private ReturnStatementVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                BooleanMethodReturnCheck.this.reportIssue((Tree)tree.expression(), "Null is returned but a \"Boolean\" is expected.");
            }
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

