/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1200", name="Classes should not be coupled to too many other classes (Single Responsibility Principle)", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="2h")
public class ClassCouplingCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="max", description="Maximum number of classes a single class is allowed to depend upon", defaultValue="20")
    public int max = 20;
    private final Deque<Set<String>> nesting = new LinkedList<Set<String>>();
    private Set<String> types;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && tree.simpleName() != null) {
            this.nesting.push(this.types);
            this.types = Sets.newHashSet();
        }
        this.checkTypes((Tree)tree.superClass());
        this.checkTypes((List<? extends Tree>)tree.superInterfaces());
        super.visitClass(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && tree.simpleName() != null) {
            if (this.types.size() > this.max) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), "Split this class into smaller and more specialized ones to reduce its dependencies on other classes from " + this.types.size() + " to the maximum authorized " + this.max + " or less.");
            }
            this.types = this.nesting.pop();
        }
    }

    public void visitVariable(VariableTree tree) {
        this.checkTypes((Tree)tree.type());
        super.visitVariable(tree);
    }

    public void visitCatch(CatchTree tree) {
        this.scan((Tree)tree.block());
    }

    public void visitTypeCast(TypeCastTree tree) {
        this.checkTypes((Tree)tree.type());
        super.visitTypeCast(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.checkTypes((Tree)tree.returnType());
        super.visitMethod(tree);
    }

    public void visitTypeParameter(TypeParameterTree typeParameter) {
        this.checkTypes((List<? extends Tree>)typeParameter.bounds());
        this.checkTypes((Tree)typeParameter.identifier());
        super.visitTypeParameter(typeParameter);
    }

    public void visitUnionType(UnionTypeTree tree) {
        this.checkTypes((List<? extends Tree>)tree.typeAlternatives());
        super.visitUnionType(tree);
    }

    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.checkTypes((Tree)tree.type());
        this.checkTypes((List<? extends Tree>)tree.typeArguments());
        super.visitParameterizedType(tree);
    }

    public void visitNewClass(NewClassTree tree) {
        if (tree.typeArguments() != null) {
            this.checkTypes((List<? extends Tree>)tree.typeArguments());
        }
        if (tree.identifier().is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            this.scan((Tree)tree.enclosingExpression());
            this.checkTypes((List<? extends Tree>)((ParameterizedTypeTree)tree.identifier()).typeArguments());
            this.scan((ListTree)tree.typeArguments());
            this.scan((ListTree)tree.arguments());
            this.scan((Tree)tree.classBody());
        } else {
            super.visitNewClass(tree);
        }
    }

    public void visitWildcard(WildcardTree tree) {
        this.checkTypes((Tree)tree.bound());
        super.visitWildcard(tree);
    }

    public void visitArrayType(ArrayTypeTree tree) {
        this.checkTypes((Tree)tree.type());
        super.visitArrayType(tree);
    }

    public void visitInstanceOf(InstanceOfTree tree) {
        this.checkTypes((Tree)tree.type());
        super.visitInstanceOf(tree);
    }

    public void visitNewArray(NewArrayTree tree) {
        this.checkTypes((Tree)tree.type());
        super.visitNewArray(tree);
    }

    private void checkTypes(List<? extends Tree> types) {
        for (Tree tree : types) {
            this.checkTypes(tree);
        }
    }

    private void checkTypes(@Nullable Tree type) {
        if (type == null || this.types == null) {
            return;
        }
        if (type.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.types.add(((IdentifierTree)type).name());
        } else if (type.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expr = (ExpressionTree)type;
            while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
                this.types.add(mse.identifier().name());
                expr = mse.expression();
            }
            if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.types.add(((IdentifierTree)expr).name());
            }
            this.types.add(((MemberSelectExpressionTree)type).identifier().name());
        }
    }
}

