/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.NoSqale;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="S124", name="Comments matching a regular expression should be handled", priority=Priority.MAJOR)
@RuleTemplate
@NoSqale
public class CommentRegularExpressionCheck
extends SubscriptionBaseVisitor {
    private static final String DEFAULT_REGULAR_EXPRESSION = "";
    private static final String DEFAULT_MESSAGE = "The regular expression matches this comment.";
    @Nullable
    private Pattern pattern = null;
    @RuleProperty(key="regularExpression", description="The regular expression", defaultValue="")
    public String regularExpression = "";
    @RuleProperty(key="message", description="The issue message", defaultValue="The regular expression matches this comment.")
    public String message = "The regular expression matches this comment.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        if (this.pattern == null && !Strings.isNullOrEmpty((String)this.regularExpression)) {
            try {
                this.pattern = Pattern.compile(this.regularExpression, 32);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Unable to compile regular expression: " + this.regularExpression, e);
            }
        }
        if (this.pattern != null && this.pattern.matcher(syntaxTrivia.comment()).matches()) {
            this.addIssue(syntaxTrivia.startLine(), this.message);
        }
    }
}

