/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3400", name="Methods should not return constants", priority=Priority.MAJOR, tags={"confusing"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ConstantMethodCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        ExpressionTree returnedExpression;
        StatementTree uniqueStatement;
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        BlockTree body = methodTree.block();
        if (BooleanUtils.isFalse((Boolean)methodTree.isOverriding()) && body != null && body.body().size() == 1 && (uniqueStatement = (StatementTree)body.body().get(0)).is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && ConstantMethodCheck.isConstant(returnedExpression = ((ReturnStatementTree)uniqueStatement).expression())) {
            this.reportIssue((Tree)returnedExpression, "Remove this method and declare a constant for this value.");
        }
    }

    private static boolean isConstant(@Nullable ExpressionTree returnedExpression) {
        return returnedExpression != null && returnedExpression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL});
    }
}

