/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.cfg.LocalVariableReadExtractor;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1854", name="Dead stores should be removed", priority=Priority.MAJOR, tags={"cert", "cwe", "suspicious", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class DeadStoreCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() == null) {
            return;
        }
        if (DeadStoreCheck.hasTryFinallyWithLocalVar(methodTree.block(), methodTree.symbol())) {
            return;
        }
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        CFG cfg = CFG.build((MethodTree)methodTree);
        LiveVariables liveVariables = LiveVariables.analyze((CFG)cfg);
        for (CFG.Block block : cfg.blocks()) {
            this.checkElements(block, liveVariables.getOut(block), methodSymbol);
        }
    }

    private void checkElements(CFG.Block block, Set<Symbol> blockOut, Symbol.MethodSymbol methodSymbol) {
        List elements = Lists.reverse((List)block.elements());
        Set<Symbol> out = new HashSet<Symbol>(blockOut);
        HashSet<ExpressionTree> assignmentLHS = new HashSet<ExpressionTree>();
        block11: for (Tree element : elements) {
            switch (element.kind()) {
                case ASSIGNMENT: {
                    AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)element;
                    ExpressionTree lhs = ExpressionsHelper.skipParentheses(assignmentExpressionTree.variable());
                    if (!lhs.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) break;
                    Symbol symbol = ((IdentifierTree)lhs).symbol();
                    if (DeadStoreCheck.isLocalVariable(symbol) && !out.contains(symbol)) {
                        this.createIssue((Tree)assignmentExpressionTree.operatorToken(), (Tree)assignmentExpressionTree.expression(), symbol);
                    }
                    assignmentLHS.add(lhs);
                    out.remove(symbol);
                    break;
                }
                case IDENTIFIER: {
                    Symbol symbol = ((IdentifierTree)element).symbol();
                    if (assignmentLHS.contains(element) || !DeadStoreCheck.isLocalVariable(symbol)) break;
                    out.add(symbol);
                    break;
                }
                case VARIABLE: {
                    out = this.handleVariable(out, (VariableTree)element);
                    break;
                }
                case NEW_CLASS: {
                    ClassTree body = ((NewClassTree)element).classBody();
                    if (body == null) break;
                    out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree((Tree)body, methodSymbol));
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    LambdaExpressionTree lambda = (LambdaExpressionTree)element;
                    out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree(lambda.body(), methodSymbol));
                    break;
                }
                case TRY_STATEMENT: {
                    TryStatementTree tryStatement = (TryStatementTree)element;
                    AssignedLocalVarVisitor visitor = new AssignedLocalVarVisitor();
                    tryStatement.block().accept((TreeVisitor)visitor);
                    out.addAll(visitor.assignedLocalVars);
                    for (CatchTree catchTree : tryStatement.catches()) {
                        out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree((Tree)catchTree, methodSymbol));
                    }
                    continue block11;
                }
                case PREFIX_DECREMENT: 
                case PREFIX_INCREMENT: {
                    Symbol symbol;
                    ExpressionTree prefixExpression = ExpressionsHelper.skipParentheses(((UnaryExpressionTree)element).expression());
                    if (!DeadStoreCheck.isParentExpressionStatement(element) || !prefixExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || !DeadStoreCheck.isLocalVariable(symbol = ((IdentifierTree)prefixExpression).symbol()) || out.contains(symbol)) break;
                    this.createIssue(element, symbol);
                    break;
                }
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: {
                    Symbol symbol;
                    ExpressionTree expression = ExpressionsHelper.skipParentheses(((UnaryExpressionTree)element).expression());
                    if (!expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || !DeadStoreCheck.isLocalVariable(symbol = ((IdentifierTree)expression).symbol()) || out.contains(symbol)) break;
                    this.createIssue(element, symbol);
                    break;
                }
                case CLASS: 
                case ENUM: 
                case ANNOTATION_TYPE: 
                case INTERFACE: {
                    ClassTree classTree = (ClassTree)element;
                    out.addAll(DeadStoreCheck.getUsedLocalVarInSubTree((Tree)classTree, methodSymbol));
                    break;
                }
            }
        }
    }

    private static boolean isParentExpressionStatement(Tree element) {
        return element.parent().is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    private void createIssue(Tree element, Symbol symbol) {
        this.reportIssue(element, DeadStoreCheck.getMessage(symbol));
    }

    private void createIssue(Tree startTree, Tree endTree, Symbol symbol) {
        this.reportIssue(startTree, endTree, DeadStoreCheck.getMessage(symbol));
    }

    private static String getMessage(Symbol symbol) {
        return "Remove this useless assignment to local variable \"" + symbol.name() + "\".";
    }

    private Set<Symbol> handleVariable(Set<Symbol> out, VariableTree localVar) {
        Symbol symbol = localVar.symbol();
        if (localVar.initializer() != null && !out.contains(symbol)) {
            this.createIssue((Tree)((VariableTreeImpl)localVar).equalToken(), (Tree)localVar.initializer(), symbol);
        }
        out.remove(symbol);
        return out;
    }

    private static List<Symbol> getUsedLocalVarInSubTree(Tree tree, Symbol.MethodSymbol methodSymbol) {
        LocalVariableReadExtractor localVarExtractor = new LocalVariableReadExtractor(methodSymbol);
        tree.accept((TreeVisitor)localVarExtractor);
        return localVarExtractor.usedVariables();
    }

    private static boolean hasTryFinallyWithLocalVar(BlockTree block, Symbol.MethodSymbol methodSymbol) {
        TryVisitor tryVisitor = new TryVisitor(methodSymbol);
        block.accept((TreeVisitor)tryVisitor);
        return tryVisitor.hasTryFinally;
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.owner().isMethodSymbol();
    }

    private static class AssignedLocalVarVisitor
    extends BaseTreeVisitor {
        List<Symbol> assignedLocalVars = new ArrayList<Symbol>();

        private AssignedLocalVarVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ExpressionTree lhs = ExpressionsHelper.skipParentheses(tree.variable());
            if (lhs.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol symbol = ((IdentifierTree)lhs).symbol();
                if (DeadStoreCheck.isLocalVariable(symbol)) {
                    this.assignedLocalVars.add(symbol);
                }
                super.visitAssignmentExpression(tree);
            }
        }
    }

    private static class TryVisitor
    extends BaseTreeVisitor {
        boolean hasTryFinally = false;
        Symbol.MethodSymbol methodSymbol;

        TryVisitor(Symbol.MethodSymbol methodSymbol) {
            this.methodSymbol = methodSymbol;
        }

        public void visitTryStatement(TryStatementTree tree) {
            BlockTree finallyBlock = tree.finallyBlock();
            this.hasTryFinally |= finallyBlock != null && !DeadStoreCheck.getUsedLocalVarInSubTree((Tree)finallyBlock, this.methodSymbol).isEmpty();
            if (!this.hasTryFinally) {
                super.visitTryStatement(tree);
            }
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

