/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1943", name="Classes and methods that rely on the default system encoding should not be used", priority=Priority.MAJOR, tags={"unpredictable"})
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class DefaultEncodingUsageCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE_ARRAY = "byte[]";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_IO_FILEWRITER = "java.io.FileWriter";
    private static final String JAVA_IO_FILEREADER = "java.io.FileReader";
    private static final String JAVA_IO_PRINTWRITER = "java.io.PrintWriter";
    private static final String JAVA_IO_PRINTSTREAM = "java.io.PrintStream";
    private static final String JAVA_IO_INPUTSTREAM = "java.io.InputStream";
    private static final String JAVA_IO_OUTPUTSTREAM = "java.io.OutputStream";
    private static final String JAVA_IO_BYTEARRAYOUTPUTSTREAM = "java.io.ByteArrayOutputStream";
    private static final String JAVA_IO_OUTPUTSTREAMWRITER = "java.io.OutputStreamWriter";
    private static final String JAVA_IO_INPUTSTREAMREADER = "java.io.InputStreamReader";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_SCANNER = "java.util.Scanner";
    private static final String JAVA_UTIL_FORMATTER = "java.util.Formatter";
    private static final String[] FORBIDDEN_TYPES = new String[]{"java.io.FileReader", "java.io.FileWriter"};
    private Set<Tree> excluded = Sets.newHashSet();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excluded.clear();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.VARIABLE);
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.excluded.contains(tree)) {
            super.visitNode(tree);
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                boolean foundIssue = this.checkForbiddenTypes((Tree)variableTree.simpleName(), variableTree.type().symbolType());
                if (foundIssue) {
                    this.excluded.add((Tree)variableTree.initializer());
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                this.checkForbiddenTypes((Tree)MethodsHelper.methodName(mit), mit.symbolType());
            }
        }
    }

    private boolean checkForbiddenTypes(Tree reportTree, Type symbolType) {
        for (String forbiddenType : FORBIDDEN_TYPES) {
            if (!symbolType.is(forbiddenType)) continue;
            this.reportIssue(reportTree, "Remove this use of \"" + forbiddenType + "\"");
            return true;
        }
        return false;
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)DefaultEncodingUsageCheck.method(JAVA_LANG_STRING, "getBytes", new String[0]), (Object)DefaultEncodingUsageCheck.method(JAVA_LANG_STRING, "getBytes", INT, INT, BYTE_ARRAY, INT), (Object)DefaultEncodingUsageCheck.constructor(JAVA_LANG_STRING, BYTE_ARRAY), (Object)DefaultEncodingUsageCheck.constructor(JAVA_LANG_STRING, BYTE_ARRAY, INT, INT), (Object)DefaultEncodingUsageCheck.method(JAVA_IO_BYTEARRAYOUTPUTSTREAM, "toString", new String[0]), (Object)DefaultEncodingUsageCheck.constructor(JAVA_IO_FILEREADER, new String[0]).withNoParameterConstraint(), (Object)DefaultEncodingUsageCheck.constructor(JAVA_IO_FILEWRITER, new String[0]).withNoParameterConstraint(), (Object)DefaultEncodingUsageCheck.constructor(JAVA_IO_INPUTSTREAMREADER, JAVA_IO_INPUTSTREAM), (Object)DefaultEncodingUsageCheck.constructor(JAVA_IO_OUTPUTSTREAMWRITER, JAVA_IO_OUTPUTSTREAM), (Object)DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM, JAVA_IO_FILE), (Object)DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM, JAVA_IO_OUTPUTSTREAM), (Object)DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM, JAVA_IO_OUTPUTSTREAM, BOOLEAN), (Object[])new MethodMatcher[]{DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM, JAVA_LANG_STRING), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER, JAVA_IO_FILE), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER, JAVA_IO_OUTPUTSTREAM), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER, JAVA_IO_OUTPUTSTREAM, BOOLEAN), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER, JAVA_LANG_STRING), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_FORMATTER, JAVA_LANG_STRING), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_FORMATTER, JAVA_IO_FILE), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_FORMATTER, JAVA_IO_OUTPUTSTREAM), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_SCANNER, JAVA_IO_FILE), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_SCANNER, JAVA_NIO_FILE_PATH), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_SCANNER, JAVA_IO_INPUTSTREAM)});
    }

    private static MethodMatcher method(String type, String methodName, String ... argTypes) {
        MethodMatcher matcher = MethodMatcher.create().typeDefinition(type).name(methodName);
        for (String argType : argTypes) {
            matcher = matcher.addParameter(argType);
        }
        return matcher;
    }

    private static MethodMatcher constructor(String type, String ... argTypes) {
        return DefaultEncodingUsageCheck.method(type, "<init>", argTypes);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "Remove this use of \"" + mit.symbol().name() + "\"");
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        Symbol symbol = newClassTree.constructorSymbol();
        if (symbol.isMethodSymbol()) {
            Symbol.MethodSymbol constructor = (Symbol.MethodSymbol)symbol;
            String signature = constructor.owner().name() + "(" + Joiner.on((char)',').join((Iterable)constructor.parameterTypes()) + ")";
            this.reportIssue((Tree)newClassTree.identifier(), "Remove this use of constructor \"" + signature + "\"");
        }
    }
}

