/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.SyntaxNodePredicates;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1186", name="Methods should not be empty", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class EmptyMethodsCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !EmptyMethodsCheck.isPublicNoArgConstructor(member)) continue;
                this.checkMethod((MethodTree)member);
            }
        }
    }

    private static boolean isPublicNoArgConstructor(Tree node) {
        return node.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)node).modifiers(), (Modifier)Modifier.PUBLIC) && ((MethodTree)node).parameters().isEmpty();
    }

    private void checkMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null && EmptyMethodsCheck.isEmpty(block) && !EmptyMethodsCheck.containsComment(block)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Add a nested comment explaining why this method is empty, throw an UnsupportedOperationException or complete the implementation.");
        }
    }

    private static boolean isEmpty(BlockTree block) {
        List body = block.body();
        return body.isEmpty() || Iterables.all((Iterable)body, SyntaxNodePredicates.kind(Tree.Kind.EMPTY_STATEMENT));
    }

    private static boolean containsComment(BlockTree block) {
        return !block.closeBraceToken().trivias().isEmpty();
    }
}

