/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2973", name="Escaped Unicode characters should not be used", priority=Priority.MAJOR, tags={"confusing"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class EscapedUnicodeCharactersCheck
extends SubscriptionBaseVisitor {
    private static final Pattern UNICODE_ESCAPED_CHAR = Pattern.compile("\\\\u+[a-fA-F0-9]{4}");
    private static final Predicate<String> IS_PRINTABLE_ESCAPED_UNICODE = new Predicate<String>(){

        public boolean apply(String input) {
            int unicodePointDecimal = Integer.parseInt(input.substring(input.length() - 4), 16);
            return 31 < unicodePointDecimal && unicodePointDecimal < 127 || 160 < unicodePointDecimal;
        }
    };

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL);
    }

    public void visitNode(Tree node) {
        String value = LiteralUtils.trimQuotes((String)((LiteralTree)node).value());
        if (value.isEmpty()) {
            return;
        }
        Matcher matcher = UNICODE_ESCAPED_CHAR.matcher(value.replaceAll("\\\\\\\\", ""));
        List<String> matches = EscapedUnicodeCharactersCheck.getAllMatches(matcher);
        if (!matches.isEmpty()) {
            boolean notOnlyUnicodeEscaped;
            boolean bl = notOnlyUnicodeEscaped = !matcher.replaceAll("").isEmpty();
            if (notOnlyUnicodeEscaped && Iterables.any(matches, IS_PRINTABLE_ESCAPED_UNICODE)) {
                this.reportIssue(node, "Remove this Unicode escape sequence and use the character instead.");
            }
        }
    }

    private static List<String> getAllMatches(Matcher matcher) {
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }
}

