/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1850", name="\"instanceof\" operators that always return \"true\" or \"false\" should be removed", priority=Priority.MAJOR, tags={"bug", "cwe"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class InstanceOfAlwaysTrueCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INSTANCE_OF);
    }

    public void visitNode(Tree tree) {
        Type instanceOf;
        InstanceOfTree instanceOfTree = (InstanceOfTree)tree;
        Type expressionType = instanceOfTree.expression().symbolType();
        if (expressionType.isSubtypeOf(instanceOf = instanceOfTree.type().symbolType())) {
            this.reportIssue((Tree)instanceOfTree.instanceofKeyword(), "Remove this useless \"instanceof\" operator; it will always return \"true\". ");
        }
    }
}

