/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2127", name="\"Double.longBitsToDouble\" should not be used for \"int\"", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class LongBitsToDoubleOnIntCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodMatcher.create().typeDefinition("java.lang.Double").name("longBitsToDouble").addParameter("long")).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Type symbolType = ((ExpressionTree)mit.arguments().get(0)).symbolType();
        if (!symbolType.is("long") && !symbolType.is("java.lang.Long")) {
            this.reportIssue((Tree)MethodsHelper.methodName(mit), "Remove this \"Double.longBitsToDouble\" call.");
        }
    }
}

