/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1479", name="\"switch\" statements should not have too many \"case\" clauses", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_CHANGEABILITY")
@SqaleConstantRemediation(value="30min")
public class SwitchWithTooManyCasesCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAXIMUM_CASES = 30;
    @RuleProperty(key="maximum", description="Maximum number of case", defaultValue="30")
    public int maximumCases = 30;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        HashSet cases = new HashSet();
        for (CaseGroupTree caseGroupTree : switchStatementTree.cases()) {
            cases.addAll(caseGroupTree.labels());
        }
        int size = cases.size();
        if (size > this.maximumCases) {
            ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>();
            for (Tree element : cases) {
                secondary.add(new JavaFileScannerContext.Location("Case + 1", element));
            }
            this.reportIssue((Tree)switchStatementTree.switchKeyword(), "Reduce the number of switch cases from " + size + " to at most " + this.maximumCases + ".", secondary, null);
        }
    }
}

