/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1217", name="Thread.run() and Runnable.run() should not be called directly", priority=Priority.CRITICAL, tags={"bug", "cert", "cwe", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ThreadRunCheck
extends AbstractMethodDetection {
    private static final MethodMatcher RUNNABLE_RUN_METHOD_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.Runnable")).name("run").withNoParameterConstraint();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)RUNNABLE_RUN_METHOD_MATCHER);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD}); parent = parent.parent()) {
        }
        if (parent != null && RUNNABLE_RUN_METHOD_MATCHER.matches((MethodTree)parent)) {
            return;
        }
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "Call the method Thread.start() to execute the content of the run() method in a dedicated thread.");
    }
}

