/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1162", name="Checked Exception should not be thrown", priority=Priority.MAJOR, tags={"error-handling"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="1h")
public class ThrowCheckedExceptionCheck
extends SubscriptionBaseVisitor {
    private Deque<MethodTree> methods = new LinkedList<MethodTree>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.THROW_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.methods.push((MethodTree)tree);
        } else {
            ThrowStatementTree throwStatementTree = (ThrowStatementTree)tree;
            Type symbolType = throwStatementTree.expression().symbolType();
            if (symbolType.isSubtypeOf("java.lang.Exception") && !symbolType.isSubtypeOf("java.lang.RuntimeException") && !this.isFromMethodOverride(symbolType)) {
                this.reportIssue((Tree)throwStatementTree.expression(), "Remove the usage of the checked exception '" + symbolType.name() + "'.");
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.methods.pop();
        }
    }

    private boolean isFromMethodOverride(Type exceptionType) {
        MethodTree method;
        return !this.methods.isEmpty() && ThrowCheckedExceptionCheck.isOverriding(method = this.methods.peek()) && ThrowCheckedExceptionCheck.isCompatibleWithThrows(exceptionType, (List<TypeTree>)method.throwsClauses());
    }

    private static boolean isCompatibleWithThrows(Type exceptionType, List<TypeTree> throwsClauses) {
        for (TypeTree typeTree : throwsClauses) {
            if (!exceptionType.isSubtypeOf(typeTree.symbolType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverriding(MethodTree methodTree) {
        return BooleanUtils.isTrue((Boolean)((MethodTreeImpl)methodTree).isOverriding());
    }
}

