/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00119", name="Type parameter names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class BadTypeParameterNameCheck
extends SubscriptionBaseVisitor {
    private static final String DEFAULT_FORMAT = "^[A-Z][0-9]?$";
    @RuleProperty(key="format", description="Regular expression used to check the type parameter names against.", defaultValue="^[A-Z][0-9]?$")
    public String format = "^[A-Z][0-9]?$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TYPE_PARAMETER);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.pattern = Pattern.compile(this.format, 32);
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        IdentifierTree identifier = ((TypeParameterTree)tree).identifier();
        if (!this.pattern.matcher(identifier.name()).matches()) {
            this.reportIssue((Tree)identifier, "Rename this generic name to match the regular expression '" + this.format + "'.");
        }
    }
}

