/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2166", name="Classes named like \"Exception\" should extend \"Exception\" or a subclass", priority=Priority.MAJOR, tags={"convention", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ClassNamedLikeExceptionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree;
        Symbol.TypeSymbol symbol;
        String className;
        if (this.hasSemantic() && (className = (symbol = (classTree = (ClassTree)tree).symbol()).name()).toLowerCase().endsWith("exception") && !symbol.type().isSubtypeOf("java.lang.Exception")) {
            String suffix = className.substring(className.length() - "exception".length());
            this.reportIssue((Tree)classTree.simpleName(), "Rename this class to remove \"" + suffix + "\" or correct its inheritance.");
        }
    }
}

