/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.web;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.xml.web.WebXmlCheckTemplate;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.w3c.dom.Node;

@Rule(key="S3355", name="Web applications should use validation filters", priority=Priority.CRITICAL, tags={"injection", "owasp-a1", "security"})
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="30min")
@ActivatedByDefault
public class ValidationFiltersCheck
extends WebXmlCheckTemplate {
    private XPathExpression filterNamesFromFilterExpression;
    private XPathExpression filterNamesFromFilterMappingExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.filterNamesFromFilterExpression = context.compile("web-app/filter/filter-name");
        this.filterNamesFromFilterMappingExpression = context.compile("web-app/filter-mapping/filter-name");
    }

    @Override
    public void scanWebXml(XmlCheckContext context) {
        Iterable filtersDefinedInFilters = context.evaluateOnDocument(this.filterNamesFromFilterExpression);
        Iterable filtersUsedInMapping = context.evaluateOnDocument(this.filterNamesFromFilterMappingExpression);
        if (Iterables.isEmpty((Iterable)filtersDefinedInFilters) || Iterables.isEmpty((Iterable)filtersUsedInMapping)) {
            this.reportIssueOnFile("Add a validation filter to this \"web.xml\".");
        } else {
            Set<String> filterNamesFromFilters = ValidationFiltersCheck.getFilterNames(filtersDefinedInFilters);
            for (Node node : filtersUsedInMapping) {
                String filterName = ValidationFiltersCheck.getStringValue(node);
                if (filterNamesFromFilters.contains(filterName)) continue;
                this.reportIssue(node, "\"" + filterName + "\" is not defined in this file.");
            }
        }
    }

    private static Set<String> getFilterNames(Iterable<Node> nodes) {
        HashSet<String> nodeByFilterName = new HashSet<String>();
        for (Node node : nodes) {
            nodeByFilterName.add(ValidationFiltersCheck.getStringValue(node));
        }
        return nodeByFilterName;
    }

    private static String getStringValue(Node node) {
        return node.getFirstChild().getNodeValue();
    }
}

