/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern PASSWORD_LITERAL_PATTERN = Pattern.compile("(password|passwd|pwd)=..", 2);
    private static final Pattern PASSWORD_VARIABLE_PATTERN = Pattern.compile("(password|passwd|pwd)", 2);

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String literalValue = ((LiteralTree)tree).value();
            if (PASSWORD_LITERAL_PATTERN.matcher(literalValue).find()) {
                this.reportIssue(tree);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variable = (VariableTree)tree;
            IdentifierTree simpleName = variable.simpleName();
            if (HardCodedCredentialsCheck.isStringLiteral(variable.initializer()) && HardCodedCredentialsCheck.isPasswordVariableName(simpleName)) {
                this.reportIssue((Tree)simpleName);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            AssignmentExpressionTree assignmentExpression = (AssignmentExpressionTree)tree;
            ExpressionTree variable = assignmentExpression.variable();
            if (HardCodedCredentialsCheck.isStringLiteral(assignmentExpression.expression()) && HardCodedCredentialsCheck.isPasswordVariable(variable)) {
                this.reportIssue((Tree)variable);
            }
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (HardCodedCredentialsCheck.isSettingPassword(mit)) {
                this.reportIssue((Tree)mit.methodSelect());
            }
        }
    }

    private static boolean isSettingPassword(MethodInvocationTree tree) {
        Arguments arguments = tree.arguments();
        return arguments.size() == 2 && HardCodedCredentialsCheck.argumentsAreLiterals((List<ExpressionTree>)arguments) && HardCodedCredentialsCheck.isPassword((LiteralTree)arguments.get(0));
    }

    private static boolean isPassword(LiteralTree argument) {
        return argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && PASSWORD_VARIABLE_PATTERN.matcher(LiteralUtils.trimQuotes((String)argument.value())).matches();
    }

    private static boolean argumentsAreLiterals(List<ExpressionTree> arguments) {
        for (ExpressionTree argument : arguments) {
            if (argument.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL})) continue;
            return false;
        }
        return true;
    }

    private static boolean isStringLiteral(@Nullable ExpressionTree initializer) {
        return initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private static boolean isPasswordVariableName(IdentifierTree identifierTree) {
        return PASSWORD_VARIABLE_PATTERN.matcher(identifierTree.name()).find();
    }

    private static boolean isPasswordVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return HardCodedCredentialsCheck.isPasswordVariableName(((MemberSelectExpressionTree)variable).identifier());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return HardCodedCredentialsCheck.isPasswordVariableName((IdentifierTree)variable);
        }
        return false;
    }

    private void reportIssue(Tree tree) {
        this.reportIssue(tree, "Remove this hard-coded password.");
    }
}

