/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S899")
public class IgnoredOperationStatusCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.io.File").name("delete"), (Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.concurrent.locks.Lock")).name("tryLock"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) || parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ((VariableTree)parent).symbol().usages().isEmpty()) {
            this.reportIssue(parent, "Do something with the \"boolean\" value returned by \"" + mit.symbol().name() + "\".");
        }
    }
}

