/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.java.model.JavaTree;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.java.syntaxtoken.LastSyntaxTokenFinder;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="IndentationCheck")
@RspecKey(value="S1120")
public class IndentationCheck
extends IssuableSubscriptionVisitor {
    private static final List<Tree.Kind> BLOCK_TYPES = ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.BLOCK, (Object)Tree.Kind.STATIC_INITIALIZER, (Object)Tree.Kind.INITIALIZER, (Object)Tree.Kind.SWITCH_STATEMENT, (Object)Tree.Kind.CASE_GROUP, (Object)Tree.Kind.METHOD_INVOCATION);
    private static final int DEFAULT_INDENTATION_LEVEL = 2;
    @RuleProperty(key="indentationLevel", description="Number of white-spaces of an indent. If this property is not set, we just check that the code is indented.", defaultValue="2")
    public int indentationLevel = 2;
    private int expectedLevel;
    private boolean isBlockAlreadyReported;
    private int lastCheckedLine;
    private Deque<Boolean> isInAnonymousClass = new LinkedList<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return BLOCK_TYPES;
    }

    public void scanFile(JavaFileScannerContext context) {
        this.expectedLevel = 0;
        this.isBlockAlreadyReported = false;
        this.lastCheckedLine = 0;
        this.isInAnonymousClass.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        if (IndentationCheck.isClassTree(tree)) {
            ClassTree classTree = (ClassTree)tree;
            this.isInAnonymousClass.push(classTree.simpleName() == null);
            if (!this.isInAnonymousClass.peek().booleanValue()) {
                this.checkIndentation(Collections.singletonList(classTree));
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.adjustMethodInvocation((MethodInvocationTree)tree);
            return;
        }
        this.expectedLevel += this.indentationLevel;
        this.isBlockAlreadyReported = false;
        switch (tree.kind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                this.checkClass((ClassTree)tree);
                break;
            }
            case CASE_GROUP: {
                this.checkCaseGroup((CaseGroupTree)tree);
                break;
            }
            case BLOCK: {
                this.checkBlock((BlockTree)tree);
                break;
            }
        }
    }

    private void adjustMethodInvocation(MethodInvocationTree tree) {
        int parenthesisLine;
        int startLine = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)tree).line();
        if (startLine != (parenthesisLine = tree.arguments().openParenToken().line())) {
            this.expectedLevel += this.indentationLevel;
        }
    }

    private void restoreMethodInvocation(MethodInvocationTree tree) {
        int parenthesisLine;
        int startLine = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)tree).line();
        if (startLine != (parenthesisLine = tree.arguments().openParenToken().line())) {
            this.expectedLevel -= this.indentationLevel;
        }
    }

    private void checkClass(ClassTree classTree) {
        if (classTree.simpleName() != null) {
            this.checkIndentation(classTree.members());
        }
    }

    private void checkBlock(BlockTree blockTree) {
        this.adjustBlockForExceptionalParents(blockTree.parent());
        this.checkIndentation(blockTree.body());
    }

    private void checkCaseGroup(CaseGroupTree tree) {
        List body;
        List labels = tree.labels();
        if (labels.size() >= 2) {
            CaseLabelTree previousCaseLabelTree = (CaseLabelTree)labels.get(labels.size() - 2);
            this.lastCheckedLine = LastSyntaxTokenFinder.lastSyntaxToken((Tree)previousCaseLabelTree).line();
        }
        List newBody = body = tree.body();
        int bodySize = body.size();
        if (bodySize > 0 && ((StatementTree)body.get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.expectedLevel -= this.indentationLevel;
            this.checkIndentation((Tree)body.get(0), ((CaseLabelTree)Iterables.getLast((Iterable)labels)).colonToken().column() + 2);
            newBody = body.subList(1, bodySize);
        }
        this.checkIndentation(newBody);
        if (bodySize > 0 && ((StatementTree)body.get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.expectedLevel += this.indentationLevel;
        }
    }

    private void adjustBlockForExceptionalParents(Tree parent) {
        if (parent.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.expectedLevel -= this.indentationLevel;
        }
    }

    private void restoreBlockForExceptionalParents(Tree parent) {
        if (parent.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.expectedLevel += this.indentationLevel;
        }
    }

    private void checkIndentation(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            this.checkIndentation(tree, this.expectedLevel);
        }
    }

    private void checkIndentation(Tree tree, int expectedLevel) {
        SyntaxToken firstSyntaxToken = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)tree);
        if (firstSyntaxToken.column() != expectedLevel && !this.isExcluded(tree, firstSyntaxToken.line())) {
            this.addIssue(((JavaTree)tree).getLine(), "Make this line start at column " + (expectedLevel + 1) + ".");
            this.isBlockAlreadyReported = true;
        }
        this.lastCheckedLine = LastSyntaxTokenFinder.lastSyntaxToken((Tree)tree).line();
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.restoreMethodInvocation((MethodInvocationTree)tree);
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.restoreBlockForExceptionalParents(tree.parent());
        }
        this.expectedLevel -= this.indentationLevel;
        this.isBlockAlreadyReported = false;
        this.lastCheckedLine = LastSyntaxTokenFinder.lastSyntaxToken((Tree)tree).line();
        if (IndentationCheck.isClassTree(tree)) {
            this.isInAnonymousClass.pop();
        }
    }

    private boolean isExcluded(Tree node, int nodeLine) {
        return node.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT}) || this.isBlockAlreadyReported || this.lastCheckedLine == nodeLine || this.isInAnonymousClass.peek() != false;
    }

    private static boolean isClassTree(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE});
    }
}

