/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="LowerCaseLongSuffixCheck")
@RspecKey(value="S1129")
public class LowerCaseLongSuffixCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.LONG_LITERAL);
    }

    public void visitNode(Tree tree) {
        LiteralTree literalTree = (LiteralTree)tree;
        if (literalTree.value().endsWith("l")) {
            this.reportIssue(tree, "Replace this lower case \"l\" long suffix by an upper case \"L\".");
        }
    }
}

