/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1845")
public class MembersDifferOnlyByCapitalizationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        List<Symbol> allMembers = MembersDifferOnlyByCapitalizationCheck.retrieveMembers(classTree.symbol());
        Multimap<String, Symbol> membersByName = MembersDifferOnlyByCapitalizationCheck.sortByName(allMembers);
        for (Tree member : classTree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                MethodTree methodTree = (MethodTree)member;
                this.checkForIssue((Symbol)methodTree.symbol(), methodTree.simpleName(), membersByName);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            VariableTree variableTree = (VariableTree)member;
            this.checkForIssue(variableTree.symbol(), variableTree.simpleName(), membersByName);
        }
    }

    private void checkForIssue(Symbol symbol, IdentifierTree reportTree, Multimap<String, Symbol> membersByName) {
        String name = symbol.name();
        block0: for (String knownMemberName : membersByName.keySet()) {
            if (!name.equalsIgnoreCase(knownMemberName)) continue;
            for (Symbol knownMemberSymbol : membersByName.get((Object)knownMemberName)) {
                if (symbol.equals(knownMemberSymbol) || !MembersDifferOnlyByCapitalizationCheck.isValidIssueLocation(symbol, knownMemberSymbol) || !MembersDifferOnlyByCapitalizationCheck.isInvalidMember(symbol, knownMemberSymbol)) continue;
                this.reportIssue((Tree)reportTree, "Rename " + MembersDifferOnlyByCapitalizationCheck.getSymbolTypeName(symbol) + " \"" + name + "\" " + "to prevent any misunderstanding/clash with " + MembersDifferOnlyByCapitalizationCheck.getSymbolTypeName(knownMemberSymbol) + " \"" + knownMemberName + "\"" + MembersDifferOnlyByCapitalizationCheck.getDefinitionPlace(symbol, knownMemberSymbol) + ".");
                continue block0;
            }
        }
    }

    private static boolean isOverriding(Symbol symbol) {
        if (symbol.isMethodSymbol()) {
            MethodTreeImpl methodDeclaration = (MethodTreeImpl)symbol.declaration();
            return methodDeclaration != null && BooleanUtils.isTrue((Boolean)methodDeclaration.isOverriding());
        }
        return false;
    }

    private static boolean isInvalidMember(Symbol currentMember, Symbol knownMember) {
        if (!MembersDifferOnlyByCapitalizationCheck.isOverriding(currentMember)) {
            return MembersDifferOnlyByCapitalizationCheck.differentTypes(currentMember, knownMember) ? MembersDifferOnlyByCapitalizationCheck.sameVisibilityNotPrivate(currentMember, knownMember) : !MembersDifferOnlyByCapitalizationCheck.sameName(currentMember, knownMember);
        }
        return false;
    }

    private static boolean isValidIssueLocation(Symbol currentMember, Symbol knownMember) {
        return !MembersDifferOnlyByCapitalizationCheck.sameOwner(currentMember, knownMember) || MembersDifferOnlyByCapitalizationCheck.isOverriding(knownMember) || MembersDifferOnlyByCapitalizationCheck.getDeclarationLine(currentMember) > MembersDifferOnlyByCapitalizationCheck.getDeclarationLine(knownMember);
    }

    private static boolean sameVisibilityNotPrivate(Symbol s1, Symbol s2) {
        return MembersDifferOnlyByCapitalizationCheck.bothPublic(s1, s2) || MembersDifferOnlyByCapitalizationCheck.bothProtected(s1, s2) || MembersDifferOnlyByCapitalizationCheck.bothPackageVisibility(s1, s2);
    }

    private static boolean bothPackageVisibility(Symbol s1, Symbol s2) {
        return s1.isPackageVisibility() && s2.isPackageVisibility();
    }

    private static boolean bothProtected(Symbol s1, Symbol s2) {
        return s1.isProtected() && s2.isProtected();
    }

    private static boolean bothPublic(Symbol s1, Symbol s2) {
        return s1.isPublic() && s2.isPublic();
    }

    private static boolean sameOwner(Symbol currentMember, Symbol knownMember) {
        return currentMember.owner().equals(knownMember.owner());
    }

    private static boolean sameName(Symbol currentMember, Symbol knownMember) {
        return currentMember.name().equals(knownMember.name());
    }

    private static boolean differentTypes(Symbol s1, Symbol s2) {
        return MembersDifferOnlyByCapitalizationCheck.variableAndMethod(s1, s2) || MembersDifferOnlyByCapitalizationCheck.variableAndMethod(s2, s1);
    }

    private static boolean variableAndMethod(Symbol s1, Symbol s2) {
        return s1.isVariableSymbol() && s2.isMethodSymbol();
    }

    private static String getDefinitionPlace(Symbol symbol, Symbol knownMemberSymbol) {
        if (MembersDifferOnlyByCapitalizationCheck.sameOwner(symbol, knownMemberSymbol)) {
            int declarationLine = MembersDifferOnlyByCapitalizationCheck.getDeclarationLine(knownMemberSymbol);
            if (declarationLine == -1) {
                return "";
            }
            return " defined on line " + declarationLine;
        }
        return " defined in " + (knownMemberSymbol.owner().isInterface() ? "interface" : "superclass") + " \"" + knownMemberSymbol.owner().type().fullyQualifiedName() + "\"";
    }

    private static int getDeclarationLine(Symbol symbol) {
        if (symbol.declaration() == null) {
            return -1;
        }
        if (symbol.isVariableSymbol()) {
            return ((Symbol.VariableSymbol)symbol).declaration().simpleName().identifierToken().line();
        }
        return ((Symbol.MethodSymbol)symbol).declaration().simpleName().identifierToken().line();
    }

    private static String getSymbolTypeName(Symbol symbol) {
        return symbol.isMethodSymbol() ? "method" : "field";
    }

    private static Multimap<String, Symbol> sortByName(List<Symbol> members) {
        LinkedListMultimap membersByName = LinkedListMultimap.create();
        for (Symbol member : members) {
            membersByName.put((Object)member.name(), (Object)member);
        }
        return membersByName;
    }

    private static List<Symbol> retrieveMembers(Symbol.TypeSymbol classSymbol) {
        LinkedList results = Lists.newLinkedList();
        results.addAll(MembersDifferOnlyByCapitalizationCheck.extractMembers(classSymbol, false));
        for (Type parentInterface : classSymbol.interfaces()) {
            results.addAll(MembersDifferOnlyByCapitalizationCheck.extractMembers(parentInterface.symbol(), true));
        }
        Type superClass = classSymbol.superClass();
        if (superClass != null) {
            results.addAll(MembersDifferOnlyByCapitalizationCheck.extractMembers(superClass.symbol(), true));
        }
        return results;
    }

    private static List<Symbol> extractMembers(Symbol.TypeSymbol classSymbol, boolean ignorePrivate) {
        LinkedList results = Lists.newLinkedList();
        for (Symbol symbol : classSymbol.memberSymbols()) {
            if (!MembersDifferOnlyByCapitalizationCheck.isVariableToExtract(symbol) && !MembersDifferOnlyByCapitalizationCheck.isMethodToExtract(symbol) || symbol.isPrivate() && ignorePrivate) continue;
            results.add(symbol);
        }
        return results;
    }

    private static boolean isVariableToExtract(Symbol symbol) {
        String name = symbol.name();
        return !symbol.isEnum() && symbol.isVariableSymbol() && !"this".equals(name) && !"super".equals(name);
    }

    private static boolean isMethodToExtract(Symbol symbol) {
        return symbol.isMethodSymbol() && !"<init>".equals(symbol.name());
    }
}

