/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.sonar.check.Rule;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.SymbolMetadataResolve;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3038")
public class RedundantAbstractMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        Symbol.MethodSymbol method = ((MethodTree)tree).symbol();
        if (method.isAbstract() && method.owner().isAbstract()) {
            this.checkMethod((JavaSymbol.MethodJavaSymbol)method);
        }
    }

    private void checkMethod(JavaSymbol.MethodJavaSymbol method) {
        JavaSymbol.MethodJavaSymbol overridee = method.overriddenSymbol();
        if (overridee != null && overridee.owner().isInterface() && !RedundantAbstractMethodCheck.differentContract(method, overridee)) {
            this.reportIssue((Tree)method.declaration(), "\"" + method.name() + "\" is defined in the \"" + overridee.owner().name() + "\" interface and can be removed from this class.");
        }
    }

    private static boolean differentContract(JavaSymbol.MethodJavaSymbol method, JavaSymbol.MethodJavaSymbol overridee) {
        return RedundantAbstractMethodCheck.removingParametrizedAspect(method, overridee) || RedundantAbstractMethodCheck.differentThrows(method, overridee) || RedundantAbstractMethodCheck.differentReturnType(method, overridee) || RedundantAbstractMethodCheck.differentParameters(method, overridee) || RedundantAbstractMethodCheck.differentAnnotations(method.metadata(), overridee.metadata());
    }

    private static boolean removingParametrizedAspect(JavaSymbol.MethodJavaSymbol method, JavaSymbol.MethodJavaSymbol overridee) {
        return !method.isParametrized() && overridee.isParametrized();
    }

    private static boolean differentThrows(JavaSymbol.MethodJavaSymbol method, JavaSymbol.MethodJavaSymbol overridee) {
        return !CollectionUtils.isEqualCollection((Collection)method.thrownTypes(), (Collection)overridee.thrownTypes());
    }

    private static boolean differentReturnType(JavaSymbol.MethodJavaSymbol method, JavaSymbol.MethodJavaSymbol overridee) {
        JavaType methodResultType = RedundantAbstractMethodCheck.resultType(method);
        JavaType overrideeResultType = RedundantAbstractMethodCheck.resultType(overridee);
        return RedundantAbstractMethodCheck.specializationOfReturnType(methodResultType.erasure(), overrideeResultType.erasure()) || RedundantAbstractMethodCheck.useRawTypeOfParametrizedType((Type)methodResultType, (Type)overrideeResultType);
    }

    private static JavaType resultType(JavaSymbol.MethodJavaSymbol method) {
        return ((MethodJavaType)method.type()).resultType();
    }

    private static boolean specializationOfReturnType(JavaType methodResultType, JavaType overrideeResultType) {
        return !methodResultType.isVoid() && methodResultType.isSubtypeOf((Type)overrideeResultType) && !overrideeResultType.isSubtypeOf((Type)methodResultType);
    }

    private static boolean differentParameters(JavaSymbol.MethodJavaSymbol method, JavaSymbol.MethodJavaSymbol overridee) {
        return RedundantAbstractMethodCheck.useRawTypeOfParametrizedType(method.parameterTypes(), overridee.parameterTypes()) || RedundantAbstractMethodCheck.differentAnnotations(method.getParameters().scopeSymbols(), overridee.getParameters().scopeSymbols());
    }

    private static boolean useRawTypeOfParametrizedType(List<Type> methodParamTypes, List<Type> overrideeParamType) {
        for (int i = 0; i < methodParamTypes.size(); ++i) {
            if (!RedundantAbstractMethodCheck.useRawTypeOfParametrizedType(methodParamTypes.get(i), overrideeParamType.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean useRawTypeOfParametrizedType(Type methodParam, Type overrideeParam) {
        return overrideeParam instanceof ParametrizedTypeJavaType && methodParam.equals(overrideeParam.erasure());
    }

    private static boolean differentAnnotations(List<JavaSymbol> methodParamSymbols, List<JavaSymbol> overrideeParamSymbols) {
        for (int i = 0; i < methodParamSymbols.size(); ++i) {
            if (!RedundantAbstractMethodCheck.differentAnnotations(methodParamSymbols.get(i).metadata(), overrideeParamSymbols.get(i).metadata())) continue;
            return true;
        }
        return false;
    }

    private static boolean differentAnnotations(SymbolMetadataResolve methodMetadata, SymbolMetadataResolve overrideeMetadata) {
        for (SymbolMetadata.AnnotationInstance annotation : methodMetadata.annotations()) {
            Type type = annotation.symbol().type();
            if (type.is("java.lang.Override") || overrideeMetadata.isAnnotatedWith(type.fullyQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

