/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.syntaxtoken.LastSyntaxTokenFinder;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="RightCurlyBraceStartLineCheck")
@RspecKey(value="S1109")
public class RightCurlyBraceStartLineCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.BLOCK, (Object)Tree.Kind.STATIC_INITIALIZER, (Object)Tree.Kind.INITIALIZER, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER, Tree.Kind.INITIALIZER})) {
            BlockTree blockTree = (BlockTree)tree;
            this.checkBlockBody(blockTree.openBraceToken(), blockTree.closeBraceToken(), blockTree.body());
        } else {
            ClassTree classTree = (ClassTree)tree;
            this.checkBlockBody(classTree.openBraceToken(), classTree.closeBraceToken(), classTree.members());
        }
    }

    private void checkBlockBody(SyntaxToken openBraceToken, SyntaxToken closeBraceToken, List<? extends Tree> trees) {
        Tree lastTree;
        SyntaxToken lastToken;
        if (openBraceToken.line() != closeBraceToken.line() && !trees.isEmpty() && (lastToken = LastSyntaxTokenFinder.lastSyntaxToken((Tree)(lastTree = trees.get(trees.size() - 1)))).line() == closeBraceToken.line()) {
            this.reportIssue((Tree)closeBraceToken, "Move this closing curly brace to the next line.");
        }
    }
}

