/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

public abstract class RightCurlyBraceToNextBlockAbstractVisitor
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatementTree = (IfStatementTree)tree;
            StatementTree thenStatement = ifStatementTree.thenStatement();
            if (ifStatementTree.elseKeyword() != null && thenStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                this.checkTokenPosition(ifStatementTree.elseKeyword(), (BlockTree)thenStatement);
            }
        } else {
            TryStatementTree tryStatementTree = (TryStatementTree)tree;
            BlockTree block = tryStatementTree.block();
            for (CatchTree catchTree : tryStatementTree.catches()) {
                this.checkTokenPosition(catchTree.catchKeyword(), block);
                block = catchTree.block();
            }
            SyntaxToken finallyKeyword = tryStatementTree.finallyKeyword();
            if (finallyKeyword != null) {
                this.checkTokenPosition(finallyKeyword, block);
            }
        }
    }

    protected abstract void checkTokenPosition(SyntaxToken var1, BlockTree var2);
}

