/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1873")
public class StaticFinalArrayNotPrivateCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        if (variableTree.type().is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE}) && StaticFinalArrayNotPrivateCheck.isStaticFinalNotPrivate(variableTree) && !StaticFinalArrayNotPrivateCheck.isExcluded(variableTree)) {
            this.reportIssue((Tree)variableTree.simpleName(), "Make this array \"private\".");
        }
    }

    private static boolean isStaticFinalNotPrivate(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.isStatic(variableTree) && StaticFinalArrayNotPrivateCheck.isFinal(variableTree) && !StaticFinalArrayNotPrivateCheck.isPrivate(variableTree);
    }

    private static boolean isStatic(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.hasModifier(variableTree, Modifier.STATIC);
    }

    private static boolean isFinal(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.hasModifier(variableTree, Modifier.FINAL);
    }

    private static boolean isPrivate(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.hasModifier(variableTree, Modifier.PRIVATE);
    }

    private static boolean hasModifier(VariableTree variableTree, Modifier modifier) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)modifier);
    }

    private static boolean isExcluded(VariableTree variableTree) {
        return StaticFinalArrayNotPrivateCheck.hasVisibleForTestingAnnotation(variableTree.modifiers().annotations());
    }

    private static boolean hasVisibleForTestingAnnotation(Iterable<AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            if (!StaticFinalArrayNotPrivateCheck.hasVisibleForTestingAnnotation(annotationTree)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVisibleForTestingAnnotation(AnnotationTree tree) {
        String id = null;
        if (tree.annotationType().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            id = ((IdentifierTree)tree.annotationType()).name();
        } else if (tree.annotationType().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            id = ((MemberSelectExpressionTree)tree.annotationType()).identifier().name();
        }
        return "VisibleForTesting".equals(id);
    }
}

