/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2209")
public class StaticMembersAccessCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.MEMBER_SELECT);
    }

    public void visitNode(Tree tree) {
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)tree;
        if (memberSelect.identifier().symbol().isStatic()) {
            ExpressionTree memberSelectExpression = memberSelect.expression();
            if (memberSelectExpression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                memberSelectExpression = ((MemberSelectExpressionTree)memberSelectExpression).identifier();
            }
            if (!memberSelectExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || ((IdentifierTree)memberSelectExpression).symbol().isVariableSymbol()) {
                this.context.reportIssue((JavaCheck)this, (Tree)memberSelect, "Change this instance-reference to a static reference.");
            }
        }
    }
}

