/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="StringEqualityComparisonCheck")
@RspecKey(value="S1127")
public class StringEqualityComparisonCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree bet = (BinaryExpressionTree)tree;
        if (bet.leftOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || bet.rightOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.reportIssue((Tree)bet.operatorToken(), "Replace \"==\" and \"!=\" by \"equals()\" and \"!equals()\" respectively to compare these strings.");
        }
    }
}

