/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S818")
public class UppercaseSuffixesCheck
extends IssuableSubscriptionVisitor {
    private static final Set<Character> LITERAL_SUFFIXES = ImmutableSet.of((Object)Character.valueOf('f'), (Object)Character.valueOf('d'), (Object)Character.valueOf('l'));

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.DOUBLE_LITERAL, (Object)Tree.Kind.FLOAT_LITERAL, (Object)Tree.Kind.LONG_LITERAL);
    }

    public void visitNode(Tree tree) {
        String value = ((LiteralTree)tree).value();
        char suffix = value.charAt(value.length() - 1);
        if (LITERAL_SUFFIXES.contains(Character.valueOf(suffix))) {
            this.reportIssue(tree, "Upper-case this literal \"" + suffix + "\" suffix.");
        }
    }
}

