/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1848")
public class UselessObjectCreationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionStatementTree expressionStatement = (ExpressionStatementTree)tree;
        ExpressionTree expression = expressionStatement.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTreeImpl newClassTree = (NewClassTreeImpl)expression;
            String className = newClassTree.getConstructorIdentifier().name();
            this.reportIssue((Tree)newClassTree.identifier(), "Either remove this useless object instantiation of class \"" + className + "\" or use it");
        }
    }
}

