/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1701")
public class FieldMatchMethodNameCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        Symbol.TypeSymbol classSymbol = ((ClassTree)tree).symbol();
        if (classSymbol != null) {
            HashMap indexSymbol = Maps.newHashMap();
            HashMultiset fields = HashMultiset.create();
            HashMap fieldsOriginal = Maps.newHashMap();
            HashSet methodNames = Sets.newHashSet();
            Collection symbols = classSymbol.memberSymbols();
            for (Symbol sym : symbols) {
                String symName = sym.name().toLowerCase(Locale.US);
                if (sym.isVariableSymbol()) {
                    indexSymbol.put(symName, sym);
                    fields.add((Object)symName);
                    fieldsOriginal.put(symName, sym.name());
                }
                if (!sym.isMethodSymbol()) continue;
                methodNames.add(symName);
            }
            fields.addAll((Collection)methodNames);
            for (Multiset.Entry entry : fields.entrySet()) {
                Tree field;
                if (entry.getCount() <= 1 || (field = ((Symbol)indexSymbol.get(entry.getElement())).declaration()) == null) continue;
                this.reportIssue((Tree)((VariableTree)field).simpleName(), "Rename the \"" + (String)fieldsOriginal.get(entry.getElement()) + "\" member.");
            }
        }
    }
}

