/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S1948")
public class SerializableFieldInSerializableClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        if (SerializableFieldInSerializableClassCheck.isSerializable((Tree)classTree) && !SerializableFieldInSerializableClassCheck.hasSpecialHandlingSerializationMethods(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                this.checkVariableMember((VariableTree)member);
            }
        }
    }

    private void checkVariableMember(VariableTree variableTree) {
        if (!SerializableFieldInSerializableClassCheck.isExcluded(variableTree)) {
            IdentifierTree simpleName = variableTree.simpleName();
            if (SerializableFieldInSerializableClassCheck.isCollectionOfSerializable(variableTree.type())) {
                if (!ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.PRIVATE)) {
                    this.reportIssue((Tree)simpleName, "Make \"" + simpleName.name() + "\" private or transient.");
                } else if (SerializableFieldInSerializableClassCheck.isUnserializableCollection(variableTree.type().symbolType()) || SerializableFieldInSerializableClassCheck.initializerIsUnserializableCollection(variableTree.initializer())) {
                    this.reportIssue(simpleName);
                }
                this.checkCollectionAssignments(variableTree.symbol().usages());
            } else {
                this.reportIssue(simpleName);
            }
        }
    }

    private static boolean initializerIsUnserializableCollection(ExpressionTree initializer) {
        return initializer != null && SerializableFieldInSerializableClassCheck.isUnserializableCollection(initializer.symbolType());
    }

    private static boolean isUnserializableCollection(Type type) {
        return !type.symbol().isInterface() && SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi(type) && !SerializableFieldInSerializableClassCheck.implementsSerializable(type);
    }

    private void checkCollectionAssignments(List<IdentifierTree> usages) {
        for (IdentifierTree usage : usages) {
            Tree parentTree = usage.parent();
            if (!parentTree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) continue;
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)parentTree;
            ExpressionTree expression = assignment.expression();
            if (!usage.equals(assignment.variable()) || expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || !SerializableFieldInSerializableClassCheck.isUnserializableCollection(expression.symbolType())) continue;
            this.reportIssue(usage);
        }
    }

    private void reportIssue(IdentifierTree tree) {
        this.reportIssue((Tree)tree, "Make \"" + tree.name() + "\" transient or serializable.");
    }

    private static boolean isExcluded(VariableTree variableTree) {
        return SerializableFieldInSerializableClassCheck.isStatic(variableTree) || SerializableFieldInSerializableClassCheck.isTransientSerializableOrInjected(variableTree);
    }

    private static boolean isCollectionOfSerializable(TypeTree typeTree) {
        Type type = typeTree.symbolType();
        if (SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi(type) && typeTree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            TypeArguments typeArgs = ((ParameterizedTypeTree)typeTree).typeArguments();
            for (Tree t : typeArgs) {
                if (SerializableFieldInSerializableClassCheck.isSerializable(t)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isSubtypeOfCollectionApi(Type type) {
        return type.isSubtypeOf("java.util.Collection") || type.isSubtypeOf("java.util.Map");
    }

    private static boolean isStatic(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean hasSpecialHandlingSerializationMethods(ClassTree classTree) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        for (Tree member : classTree.members()) {
            MethodTree methodTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !ModifiersUtils.hasModifier((ModifiersTree)(methodTree = (MethodTree)member).modifiers(), (Modifier)Modifier.PRIVATE) || methodTree.parameters().size() != 1) continue;
            hasWriteObject |= "writeObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 1;
            hasReadObject |= "readObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 2;
        }
        return hasReadObject && hasWriteObject;
    }

    private static boolean isTransientSerializableOrInjected(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.TRANSIENT) || SerializableFieldInSerializableClassCheck.isSerializable((Tree)member.type()) || member.symbol().metadata().isAnnotatedWith("javax.inject.Inject");
    }

    private static boolean isSerializable(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM, Tree.Kind.PRIMITIVE_TYPE})) {
            return true;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            Symbol.TypeSymbol symbol = ((ClassTree)tree).symbol();
            return SerializableFieldInSerializableClassCheck.implementsSerializable(symbol.type());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD, Tree.Kind.UNBOUNDED_WILDCARD})) {
            TypeTree bound = ((WildcardTree)tree).bound();
            return bound != null && SerializableFieldInSerializableClassCheck.implementsSerializable(bound.symbolType());
        }
        return SerializableFieldInSerializableClassCheck.implementsSerializable(((TypeTree)tree).symbolType());
    }

    private static boolean implementsSerializable(@Nullable Type type) {
        if (type == null || type.isUnknown() || type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return SerializableFieldInSerializableClassCheck.implementsSerializable(((Type.ArrayType)type).elementType());
        }
        if (type.isClass() || ((JavaType)type).isTagged(15)) {
            return type.erasure().isSubtypeOf("java.io.Serializable");
        }
        return false;
    }
}

