/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.signature.JvmJavaType;
import org.sonar.java.signature.MethodSignatureScanner;
import org.sonar.java.signature.Parameter;
import org.sonar.plugins.java.api.JavaCheck;

@Rule(key="UnusedPrivateMethod")
@RspecKey(value="S1144")
public class UnusedPrivateMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (UnusedPrivateMethodCheck.isPrivateUnused(asmMethod) && !UnusedPrivateMethodCheck.isExcludedFromCheck(asmMethod)) {
            String messageStr = "Private method '" + asmMethod.getName() + "' is never used.";
            if ("<init>".equals(asmMethod.getName())) {
                messageStr = "Private constructor '" + this.asmClass.getDisplayName() + "(";
                ArrayList params = Lists.newArrayList();
                for (Parameter param : MethodSignatureScanner.scan((String)asmMethod.getGenericKey()).getArgumentTypes()) {
                    String paramName = param.getClassName();
                    if (StringUtils.isEmpty((String)paramName)) {
                        paramName = MethodSignatureScanner.getReadableType((JvmJavaType)param.getJvmJavaType());
                    }
                    params.add(paramName + (param.isArray() ? "[]" : ""));
                }
                messageStr = messageStr + Joiner.on((String)",").join((Iterable)params) + ")' is never used.";
            }
            int line = this.getMethodLineNumber(asmMethod);
            this.getContext().reportIssue((JavaCheck)this, this.getSourceFile(this.asmClass), messageStr, line);
        }
    }

    private static boolean isPrivateUnused(AsmMethod asmMethod) {
        return !asmMethod.isUsed() && asmMethod.isPrivate();
    }

    private static boolean isExcludedFromCheck(AsmMethod asmMethod) {
        return asmMethod.isSynthetic() || asmMethod.isDefaultConstructor() || SerializableContract.methodMatch(asmMethod);
    }
}

