/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.plugins.java.api.JavaCheck;

@Rule(key="UnusedProtectedMethod")
@RspecKey(value="S1815")
public class UnusedProtectedMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (UnusedProtectedMethodCheck.isUnusedNonOverridenProtectedMethod(asmMethod) && !this.asmClass.isAbstract() && !SerializableContract.methodMatch(asmMethod)) {
            int methodLineNumber = this.getMethodLineNumber(asmMethod);
            this.getContext().reportIssue((JavaCheck)this, this.getSourceFile(this.asmClass), "Protected method '" + asmMethod.getName() + "(...)' is never used.", methodLineNumber);
        }
    }

    private static boolean isUnusedNonOverridenProtectedMethod(AsmMethod asmMethod) {
        return !asmMethod.isUsed() && asmMethod.isProtected() && !asmMethod.isInherited();
    }
}

