/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.java.xml.maven.PomCheck;
import org.sonar.java.xml.maven.PomCheckContext;
import org.sonar.maven.model.LocatedAttribute;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.MavenProject;

public abstract class AbstractNamingConvention
implements PomCheck {
    private Pattern pattern = null;

    public void scanFile(PomCheckContext context) {
        NamedLocatedAttribute namedAttribute;
        String regex = this.getRegex();
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(regex, 32);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + this.getRuleKey() + "] Unable to compile the regular expression: " + regex, e);
            }
        }
        if ((namedAttribute = this.getTargetedLocatedAttribute(context.getMavenProject())).attribute != null && !this.pattern.matcher(namedAttribute.attribute.getValue()).matches()) {
            context.reportIssue((PomCheck)this, (LocatedTree)namedAttribute.attribute, "Update this \"" + namedAttribute.name + "\" to match the provided regular expression: '" + regex + "'");
        }
    }

    protected abstract String getRegex();

    protected abstract String getRuleKey();

    protected abstract NamedLocatedAttribute getTargetedLocatedAttribute(MavenProject var1);

    protected static class NamedLocatedAttribute {
        private final String name;
        @Nullable
        private final LocatedAttribute attribute;

        public NamedLocatedAttribute(String name, @Nullable LocatedAttribute attribute) {
            this.name = name;
            this.attribute = attribute;
        }
    }
}

