/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.spring;

import com.google.common.collect.Iterables;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.java.xml.XmlCheckUtils;
import org.w3c.dom.Node;

@Rule(key="S3438")
public class SingleConnectionFactoryCheck
extends XPathXmlCheck {
    private XPathExpression singleConnectionFactoryBeansExpression;
    private XPathExpression reconnectOnExceptionPropertyValueExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.singleConnectionFactoryBeansExpression = context.compile("beans/bean[@class='org.springframework.jms.connection.SingleConnectionFactory']");
        this.reconnectOnExceptionPropertyValueExpression = context.compile("property[@name='reconnectOnException' and value='true']");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        for (Node bean : context.evaluateOnDocument(this.singleConnectionFactoryBeansExpression)) {
            if (SingleConnectionFactoryCheck.hasPropertyAsAttribute(bean) || this.hasPropertyAsChild(bean, context)) continue;
            this.reportIssue(bean, "Add a \"reconnectOnException\" property, set to \"true\"");
        }
    }

    private static boolean hasPropertyAsAttribute(Node bean) {
        Node attribute = XmlCheckUtils.nodeAttribute((Node)bean, (String)"p:reconnectOnException");
        return attribute != null && "true".equals(attribute.getNodeValue());
    }

    private boolean hasPropertyAsChild(Node bean, XmlCheckContext context) {
        return !Iterables.isEmpty((Iterable)context.evaluate(this.reconnectOnExceptionPropertyValueExpression, bean));
    }
}

