/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.DiscreteDomains;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ranges;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.api.issue.Issue;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.java.syntaxtoken.LastSyntaxTokenFinder;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class BaseTreeVisitorIssueFilter
extends BaseTreeVisitor
implements JavaIssueFilter {
    private String componentKey;
    private final Multimap<String, Integer> excludedLinesByRule = HashMultimap.create();
    private final Map<Class<? extends JavaCheck>, String> rulesKeysByRulesClass = BaseTreeVisitorIssueFilter.rulesKeysByRulesClass(this.filteredRules());

    private static Map<Class<? extends JavaCheck>, String> rulesKeysByRulesClass(Set<Class<? extends JavaCheck>> rules) {
        HashMap results = Maps.newHashMap();
        for (Class<? extends JavaCheck> ruleClass : rules) {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
            if (ruleAnnotation == null) continue;
            results.put(ruleClass, ruleAnnotation.key());
        }
        return results;
    }

    @Override
    public void setComponentKey(String componentKey) {
        this.componentKey = componentKey;
    }

    public void scanFile(JavaFileScannerContext context) {
        this.excludedLinesByRule.clear();
        this.scan((Tree)context.getTree());
    }

    @Override
    public boolean accept(Issue issue) {
        return !issue.componentKey().equals(this.componentKey) || !this.excludedLinesByRule.get((Object)issue.ruleKey().rule()).contains(issue.line());
    }

    public Multimap<String, Integer> excludedLinesByRule() {
        return this.excludedLinesByRule;
    }

    public void acceptLines(Tree tree, Iterable<Class<? extends JavaCheck>> rules) {
        for (Class<? extends JavaCheck> rule : rules) {
            this.acceptLines(tree, rule);
        }
    }

    public void acceptLines(Tree tree, Class<? extends JavaCheck> rule) {
        this.computeFilteredLinesForRule(tree, rule, false);
    }

    public void excludeLines(Tree tree, Iterable<Class<? extends JavaCheck>> rules) {
        for (Class<? extends JavaCheck> rule : rules) {
            this.excludeLines(tree, rule);
        }
    }

    public void excludeLines(Set<Integer> lines, String ruleKey) {
        this.computeFilteredLinesForRule(lines, ruleKey, true);
    }

    public void excludeLines(Tree tree, Class<? extends JavaCheck> rule) {
        this.computeFilteredLinesForRule(tree, rule, true);
    }

    private void computeFilteredLinesForRule(Tree tree, Class<? extends JavaCheck> filteredRule, boolean excludeLine) {
        SyntaxToken firstSyntaxToken = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)tree);
        SyntaxToken lastSyntaxToken = LastSyntaxTokenFinder.lastSyntaxToken((Tree)tree);
        if (firstSyntaxToken != null && lastSyntaxToken != null) {
            HashSet filteredlines = Sets.newHashSet((Iterable)Ranges.closed((Comparable)Integer.valueOf(firstSyntaxToken.line()), (Comparable)Integer.valueOf(lastSyntaxToken.line())).asSet(DiscreteDomains.integers()));
            this.computeFilteredLinesForRule(filteredlines, this.rulesKeysByRulesClass.get(filteredRule), excludeLine);
        }
    }

    private void computeFilteredLinesForRule(Set<Integer> lines, String ruleKey, boolean excludeLine) {
        if (excludeLine) {
            this.excludedLinesByRule.putAll((Object)ruleKey, lines);
        } else {
            this.excludedLinesByRule.get((Object)ruleKey).removeAll(lines);
        }
    }
}

